package com.vmware.samples.globalview;

/**
 * Interface for reading and updating some settings data.
 *
 * See how it is declared as osgi:service with the same name in
 * main/resources/META-INF/spring/bundle-context-osgi.xml
 */
public interface GlobalService {

   /**
    * @return the current GlobalSettings data
    */
   public GlobalSettings getSettings();

   /**
    * Update settings on the server.
    *
    * @param settings  the GlobalSettings data to update
    * @throws Exception if the data persistence fails
    */
   public void setSettings(GlobalSettings settings) throws Exception;
}
